# SQLite-RAG スターター（高速モード/ストリーミング対応版）

このコードは [amaiya/sqlite-rag](https://github.com/amaiya/sqlite-rag) をベースに改変・再構成したものです（MIT License）。

## 動作環境
- Python 3.10+
- Windows / macOS / Linux
- LM Studio（OpenAI互換APIを有効化）または OpenAI API

## インストール
```bash
python -m venv .venv
# Windows:
.venv\Scripts\activate
# macOS/Linux:
# source .venv/bin/activate

pip install -r requirements.txt
```

## 使い方
1. PDFやテキストを `data` フォルダに配置
2. ベクトル化してDBに登録
   ```bash
   python sqlite_rag.py ingest --data ./data
   ```
3. 一発質問（体感重視の高速モード）
   ```bash
   python sqlite_rag.py ask --q "このPDFの要旨を3点で" --k 4 --fast
   ```
4. 常駐REPL
   ```bash
   python sqlite_rag.py repl --fast
   ```

## 設定（環境変数）
- `OPENAI_BASE` : 既定は `http://localhost:1234/v1`（LM StudioのLocal Server）
- `OPENAI_API_KEY` : 任意文字列で可（LM Studioの場合）
- `OPENAI_MODEL` : 例 `gemma-3-4b-it`
- `GEN_MAX_TOKENS` : 既定 192（要約時は内部で 160）
- `FAST_MODE` : `1` で既定を高速モードに

## メモ
- `--fast` は MMR を省略し、短文チャンク（≈480字）＋ストリーミングで**出始めを早く**します
- 応答速度はモデル/ハードウェア/トークン長に依存します
- 学習・検証用途を想定。実運用では監査ログや権限制御を追加してください
