# LLM Double-Take (日本語原稿の二度見レビュー)

LM Studio / OpenAI 互換APIで、*.txt / *.md を一括レビューします。問題がある原稿だけに
`.review.json` / `.diff.txt` / 修正後 `.txt` を出力します。ローカル完結で運用できます。

## 使い方（最短）
1. LM Studio を起動（OpenAI 互換 API を ON）。base_url は `http://localhost:1234/v1`。
2. `samples/drafts/` のサンプル or 手持ちの原稿を用意。
3. 実行（PowerShell）:
   ```powershell
   python .\llm_double_take.py --in samples\drafts --out samples\reviewed --log samples\logs\review.log ^
     --provider lmstudio --base_url "http://localhost:1234/v1" --model "<LM StudioのモデルID>" ^
     --no-jsonfmt --strict --only-problem
   ```

## 主なオプション
- `--strict`：カテゴリ別の pass/fail を `checks[]` で可視化
- `--only-problem`：問題ありの原稿だけ成果物を出力
- `--no-jsonfmt`：一部モデルの 400 対策（`response_format` 非対応）
- `--notes`：人手レビュー用の Markdown ノートを出力
- `--tone formal|casual`：文体トーン

## 出力
- `<name>.review.json`：`issues[] / checks[] / fixed_text`
- `<name>.diff.txt`：原稿→修正後の行差分（unified diff）
- `<name>.txt/.md`：修正後本文

## 注意
- 目的は「言語の整形支援」です。内容の真偽・剽窃チェックは対象外。
- コードフェンス（```）内は変更しない前提。閉じ忘れに注意。

## ライセンス
MIT License（`LICENSE` を参照）
